//
//  BIQueryHandler.h
//  BISubstrate
//
//  Created by Eric Hochmeister on 06/01/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class MCPDatabaseObjectContext, BIUser, BIClient, BIProjectState;
@class BIExtraFieldNames;
@class BITimeSlipType;
@class BIConsolidatedTax;
@class BIPaymentMethodType;
@class ABPerson;
@class BIUser;
@class BIProject;
@class BITimeSlip;
@class BIEstimateSlip;
@class BIBEXIgnore;
@class BICurrency;

#ifdef BILLINGS_PRO
@class BIIdentity;
#endif

/*!
@class       BIQueryHandler
@abstract    Query Handler is responsible for abstracting out commonly used queries.
@discussion  Query Handler hangs off of the object context.  Its main purpose is to act as a collection for query methods which hit hte database.  We can always ensure it has access to the database as it has a handle on the object context.  The methods here are abstracting out common queries so that we aren't always constructing qualifiers for repetitive operations.
*/



@interface BIQueryHandler : NSObject {

		MCPDatabaseObjectContext* _context;

}

- (id)initWithObjectContext:(MCPDatabaseObjectContext*)context;

- (MCPDatabaseObjectContext*)objectContext;
- (void)setObjectContext:(MCPDatabaseObjectContext*)context;

- (BIClient*)meClient;

- (BIClient*)clientWithABUID:(NSString*)anABID
                   firstname:(NSString*)fname
                    lastname:(NSString*)lname
                       email:(NSString*)emailAddr
                     company:(NSString*)company;
- (BIClient*)clientWithFirstname:(NSString*)fname 
                        lastname:(NSString*)lname 
                           email:(NSString*)emailAddr
                         company:(NSString*)company;
- (BIClient*)clientWithABUID:(NSString*)abUID;
- (BIClient*)clientWithPrimaryKey:(id)aValue;
- (BIClient*)clientForABPerson:(ABPerson*)aPerson;
- (NSArray*)clients;
- (NSArray*)clientsIncludingMe;

- (NSArray*)projects;
- (NSArray*)projectsForClient:(BIClient*)aClient;

- (NSArray*)projectStages;
- (NSArray*)projectStates;
- (BIProjectState *)projectStateForStateCode:(NSNumber *)aCode;
- (NSArray*)timeSlipTypes;

- (NSArray*)activeTimedTimeSlips;
- (NSArray*)activeProjects;

- (NSArray*)notLinkedTimedSlips;

- (NSArray*)projectsWithActiveForTimingSlips;

- (NSArray*)activeTimerSlips;

- (NSArray*)recurringInvoices;
- (NSNumber *)countOfRecurringInvoicesToBeSent;

- (NSArray*)categories;

- (NSArray*)clientCategories;

- (NSArray*)paymentMethodTypes;
- (NSArray *)retainerPaymentMethodTypes;

- (NSArray*)slipTemplates;

- (BIExtraFieldNames*)projectExtraFieldNames;
- (BIExtraFieldNames*)clientExtraFieldNames;
- (BIExtraFieldNames*)extraFieldNamesForEntityValue:(int)aValue;

- (BITimeSlipType*)timedSlipType;
- (BITimeSlipType*)slipTypeFromCode:(int)typeCode;

- (NSArray*)activeTaxes;
- (NSArray*)activeConsolidatedTaxes;
- (NSArray *)activeConsolidatedTaxNamed:(NSString *)aTaxName;
- (NSArray*)activeNotAtomicConsolidatedTaxes;
- (NSArray*)consolidatedTaxes;
- (NSArray*)taxes;
- (NSArray*)taxesWithName:(NSString*)aName;
- (BIConsolidatedTax*)consolidatedTaxWithID:(NSNumber*)anID;

- (NSArray*)childConsolidatedTaxesForParents:(NSArray*)consTaxes;

- (NSArray*)taxesAppliedInDateRangeStart:(NSCalendarDate*)startDate
                                     end:(NSCalendarDate*)endDate;

- (BIPaymentMethodType*)retainerPaymentMethodType;

- (NSArray*)timeslipActivityInDateRangeStart:(NSCalendarDate*)startDate
                                         end:(NSCalendarDate*)endDate;

- (BIPaymentMethodType*)paymentMethodTypeWithID:(NSNumber*)anID;

- (NSArray*)sortedUsers;
- (NSArray *)sortedUsersWithoutPrimaryUser;
- (BIUser *)primaryUser;
- (BIUser *)userWithUsername:(NSString *)aName;

// returns the last project found with this code or nil
- (BIProject*)projectForProjectCode:(NSString *)aCode;

- (BIProject*)projectWithForeignAppName:(NSString*)foreignAppName
                   foreignAppEntityName:(NSString*)foreignEntityName
                     foreignAppImportID:(NSString*)foreignAppID;

- (BIEstimateSlip*)estimateSlipWithForeignAppName:(NSString*)foreignAppName
                             foreignAppEntityName:(NSString*)foreignEntityName
                               foreignAppImportID:(NSString*)foreignAppID;

- (BITimeSlip*)timeSlipWithForeignAppName:(NSString*)foreignAppName
                     foreignAppEntityName:(NSString*)foreignEntityName
                       foreignAppImportID:(NSString*)foreignAppID;

- (BITimeSlip*)timeSlipWithSlipID:(NSNumber *)aSlipID;

- (id)objectForEntityNamed:(NSString*)anEntityName
            foreignAppName:(NSString*)foreignAppName
      foreignAppEntityName:(NSString*)foreignEntityName
        foreignAppImportID:(NSString*)foreignAppID;

- (BIProject*)looseSlipsProjectForClient:(BIClient*)aClient DEPRECATED_IN_MAC_OS_X_VERSION_10_6_AND_LATER;

// combined working and estimate slips
- (NSArray*)allSlips; 
- (NSArray*)activeSlips;
- (NSArray*)allEstimateSlips;
- (NSArray*)allInvoicedSlips;
- (NSArray*)invoicedSlipsSinceDate:(NSCalendarDate *)aDate;
- (NSArray*)allWorkingSlips;
- (NSArray*)allMyEyesOnlySlips;
- (NSArray*)slipsWorkedOnInRangeStart:(NSCalendarDate*)startDate end:(NSCalendarDate*)endDate;
- (NSArray*)slipsWorkedOnDate:(NSCalendarDate*)aDate;
- (NSArray*)slipsWorkedOnToday;
- (NSArray*)slipsWorkedOnYesterday;
- (NSArray*)slipsWorkedOnThisWeek;
- (NSArray*)lastImportedSlips;
- (NSArray*)lastImportedWorkingSlips;
- (NSArray*)lastImportedEstimateSlips;
- (NSArray*)workingSlipsImportedFromOtherUsers;
- (NSArray*)estimateSlipsImportedFromOtherUsers;
- (NSArray*)slipsImportedFromOtherUsers;
- (NSArray*)slipsImportedFromApplicationNamed:(NSString*)appName;
- (NSArray*)workingSlipsImportedFromApplicationNamed:(NSString*)appName;
- (NSArray*)estimateSlipsImportedFromApplicationNamed:(NSString*)appName;
- (NSArray*)slipsImportedFromDaylite;
- (NSArray*)workingSlipsImportedFromDaylite;
- (NSArray*)estimateSlipsImportedFromDaylite;
- (NSArray*)slipsImportedFromMerlin;
- (NSArray*)workingSlipsImportedFromMerlin;
- (NSArray*)estimateSlipsImportedFromMerlin;
- (NSArray*)slipsDueInRangeStart:(NSCalendarDate*)startDate end:(NSCalendarDate*)endDate;
- (NSArray*)slipsDueToday;
- (NSArray*)slipsDueTomorrow;
- (NSArray*)slipsDueInNextWeek;
- (NSArray*)slipsDueByDate:(NSCalendarDate*)byDate;
- (NSArray*)slipsForUser:(BIUser *)aUser;
- (NSArray*)unfiledSlips;

- (BIBEXIgnore*)bexIgnoreObjectWithForeignAppName:(NSString*)appName
                             foreignAppEntityName:(NSString*)entityName
                               foreignAppImportID:(NSString*)importID;

- (BIBEXIgnore*)bexIgnoreObjectForObject:(id)anObj;
    
- (NSArray*)applicationNamesForImportedSlipsProjects;

// projects
- (NSArray*)lastImportedProjects;

- (NSArray*)filterBEXIgnoresFromSlips:(NSArray*)slipsArray;

// returns all objects that need to determine the state of the account for a client. If client is nil, then all account objects are returned. At this point, account objects are: Invoice, Retainer, Payment, Statement (for history)
- (NSArray *)sortedAccountObjectsForClient:(BIClient *)aClient;



// Search view support

- (NSArray *)clientSearchResultsForString:(NSString *)aStr;
- (NSArray *)activeProjectSearchResultsForString:(NSString *)aStr;
- (NSArray *)estimateProjectSearchResultsForString:(NSString *)aStr;
- (NSArray *)inactiveProjectSearchResultsForString:(NSString *)aStr;
- (NSArray *)workingSlipSearchResultsForString:(NSString *)aStr;
- (NSArray *)estimateSlipSearchResultsForString:(NSString *)aStr;
- (NSArray *)invoicedSlipSearchResultsForString:(NSString *)aStr;
- (NSArray *)invoiceSearchResultsForString:(NSString *)aStr;
- (NSArray *)estimateSearchResultsForString:(NSString *)aStr;
- (NSArray *)paymentSearchResultsForString:(NSString *)aStr;
- (NSArray *)retainerSearchResultsForString:(NSString *)aStr;
- (NSArray *)statementSearchResultsForString:(NSString *)aStr;
- (NSArray *)noteSearchResultsForString:(NSString *)aStr;
- (NSArray *)fileSearchResultsForString:(NSString *)aStr;
- (NSArray *)recurringInvoiceResultsForString:(NSString *)aStr;


// End Search view support

- (NSArray *)currencies;
- (NSArray *)currenciesWithoutBaseCurrency;

- (BICurrency *)baseCurrency;
- (BICurrency *)currencyWithCurrencyCode:(NSString *)aCode;
- (NSArray *)clientsWithCurrency:(BICurrency *)cur;

- (NSNumber *)totalInvoicedForCurrency:(BICurrency *)cur from:(NSCalendarDate *)start to:(NSCalendarDate *)end;
- (NSNumber *)totalCollectedForCurrency:(BICurrency *)cur from:(NSCalendarDate *)start to:(NSCalendarDate *)end;
- (NSArray *)totalInvoicedAndCollectedByCurrencyFrom:(NSCalendarDate *)start to:(NSCalendarDate *)end;


#ifdef BILLINGS_PRO

- (BIIdentity *)defaultIdentity;

- (NSArray *)sortedActiveUsersWithInactiveOwnerFromSlip:(id)aWorkingOrEstimateSlip;
- (NSArray *)sortedActiveUsers;
- (NSArray *)sortedActiveUsersWithTimeCardAccess;
- (NSArray *)sortedActiveApprovers;
- (BIUser *)userForUserID:(NSNumber *)aUserID;

/*!
 Returns slips that need to be approved by that specific user. If aUser is nil, returns all slips that have to be approved.
 */
- (NSArray *)timeSlipsToBeApprovedBy:(BIUser *)aUser;
- (NSNumber *)countOfAllUnapprovedSlips;
- (NSNumber *)countOfUnapprovedSlipsForUser:(BIUser *)aUser;
- (NSNumber *)countOfUnapprovedSlipsForCurrentUser;

- (NSArray *)projectsForPunchcardUserID:(NSNumber *)aUserID;
- (NSArray *)projectsWithCompletedSlipsForPunchcardUserID:(NSNumber *)aUserID;

- (NSArray *)workingSlipsInProjectWithID:(NSNumber *)aProjectID forPunchcardUserID:(NSNumber *)aUserID;
- (NSArray *)slipsInProjectWithID:(NSNumber *)aProjectID completedSince:(NSDate *)date forPunchcardUserID:(NSNumber *)aUserID;
- (BOOL)isPunchcardUser:(NSNumber *)aUserID aWorkerOnProject:(NSNumber *)aProjectID;

- (BIProject *)projectForProjectID:(NSNumber *)aProjectID;
- (BITimeSlip *)timeSlipForTimeSlipID:(NSNumber *)aTimeSlipID;

/*!
 Returns an array of BIReportTemplate
 */
- (NSArray *)reportTemplatesForEntityNamed:(NSString *)entName matchingBehaviors:(NSArray *)behavs;



- (NSArray *)objectsForEntityNamed:(NSString *)entName withConnectorMapsToForeignApp:(NSString *)anApp foreignEntityType:(NSString *)aForeignEnt foreignID:(NSString *)aForeignID;

- (NSArray *)objectsForEntityNamed:(NSString *)entName withConnectorMapsToForeignApp:(NSString *)anApp foreignEntityType:(NSString *)aForeignEnt;

- (NSArray *)objectsForEntityNamed:(NSString *)entName withNoConnectorMapsToForeignApp:(NSString *)anApp;

- (NSArray *)activeProjectsFromDaylite;

#endif



@end
